﻿var NUM_DEV_CARD = 4;
var language;

function mouseOverShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_hover.png)";
	}
}
function mouseOutShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_normal.png)";
	}
}
function CardConfigDisplay()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=27&cmd=1&getCardConfig=1";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var cardData = response.split("&");
			var i,id;
			
			/* Main Board - IP Address */
			for(i = 0; i < NUM_DEV_CARD; i++)
			{
				id = i + 1;
				document.getElementById("card_reset_" + id).value = cardData[i];
			}
			
			document.body.style.cursor="auto";
			window.status = "Done";
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function PageLoadHandler()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	CardConfigDisplay();
}

function pageRefresh()
{
	PageLoadHandler();
}

var showAdvancedFlag = false;
function displayAdvancedParam()
{
	if(showAdvancedFlag == false)
	{
		$("#kernelUpdateTr").show();
		$("#updateSwitchTr").show();
		showAdvancedFlag = true;
		if(language == 0)
		{
			$("#advancedOption").val("Hide Advanced Options");
		}
		else
		{
			$("#advancedOption").val("隐藏高级选项");
		}
	}
	else
	{
		$("#kernelUpdateTr").hide();
		$("#updateSwitchTr").hide();
		showAdvancedFlag = false;
		if(language == 0)
		{
			$("#advancedOption").val("Show Advanced Options");
		}
		else
		{
			$("#advancedOption").val("显示高级选项");
		}
	}
}

/****************************************************************
	Populates the Channel table on page load
****************************************************************/
window.onload = function()
{
	var args = getArgs();
	userName = args["userName"];
	language = document.getElementById("language").value;
	PageLoadHandler();
}


function CardResetConfig()
{
	var i,id;
	/* Generate params to POST from the from controls*/
	var params = "type=27&cmd=2&";
	
	for(var i = 0; i < NUM_DEV_CARD; i++)
	{
		id = i + 1;
		var card_reset = document.getElementById("card_reset_" + id).value;
		params = params + "card_reset_" + id + "=" + card_reset + "&";
	}


	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Card update configuration updated successfully.");
			}
			else
			{
				alert("卡复位参数已设置成功。");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(params)
	return;
}

function SetCardReset()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Applying settings, please wait...";
	
	CardResetConfig();	
}

var rebootType = 0;
function CardReboot(cardNo)
{
	var xmlhttp = getHTTPObject();
	var params = "type=27&cmd=2&rebootCardNo=" + cardNo + "&userName=" + userName + "&rebootType=" + rebootType;
	
	var confirmResult;
	if(rebootType == 0)
	{
		if(language == 0)
		{
			confirmResult = confirm("Card " + cardNo + "will reboot, All unsaved configuration and connection to the Card will be lost.\r\nContinue?");
		}
		else
		{
			confirmResult = confirm("卡" + cardNo + "将重启，所有未保存的设置或连接将丢失。\r\n确定继续？");
		}
	}
	else
	{
		confirmResult = true;
	}
	if(confirmResult == true)
	{
		xmlhttp.open("POST", "/goform/formIPQAM", true);
		xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlhttp.setRequestHeader("Content-length", params.length);
		
		xmlhttp.onreadystatechange = function()
		{
			if(xmlhttp.readyState == 4)
			{
				rebootType = 0;
				if(xmlhttp.responseText.match("CardRebootAllowed"))
				{
					if(language == 0)
					{
						alert("Card reboot succseefully, please wait.");
					}
					else
					{
						alert("卡成功重启，请耐心等待。");
					}
				}
				else if(xmlhttp.responseText.match("CardRebootUnallowed"))
				{
					if(language == 0)
					{
						var rebootConfirmResult = confirm("Card is saving parameters now. \r\nContinue?");
					}
					else
					{
						var rebootConfirmResult = confirm("卡正在保存参数。\r\n确定继续？");
					}
					if(rebootConfirmResult == true)
					{
						rebootType = 1;
						CardReboot(cardNo);
					}
				}
				else
				{
					if(language == 0)
					{
						alert("Card reboot operation is failed!");
					}
					else
					{
						alert("卡重启失败！");
					}
				}
			}
		}
		xmlhttp.send(params);
	}
	else 
	{
		return false;
	}
	
}
var updateType = 0;
function CardUpdate(cardNo)
{	
	var confirmResult;
	if(updateType == 0)
	{
		if(language == 0)
		{
			confirmResult = confirm("Please make sure the card's network connection is normal.\r\nContinue?");
		}
		else
		{
			confirmResult = confirm("请确定卡网络连接正常！\r\n确定继续？");
		}
	}
	else
	{
		confirmResult = true;
	}
	if(confirmResult == true)
	{
		var xmlhttp = getHTTPObject();
		var params = "type=27&cmd=2&cardUpdataKernel=" + cardNo + "&userName=" + userName + "&updateType=" + updateType ;
		xmlhttp.open("POST", "/goform/formIPQAM", true);
		xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlhttp.setRequestHeader("Content-length", params.length);
		
		xmlhttp.onreadystatechange = function()
		{
			if(xmlhttp.readyState == 4)
			{
				updateType = 0;
				if(xmlhttp.responseText.match("updateSuccessful"))
				{
					if(language == 0)
					{
						alert("Card " + cardNo +  " kernel update succseefully, the card is rebooting, please wait.");
					}
					else
					{
						alert("卡" + cardNo + "内核升级成功，正在重启，请耐心等待。");
					}
					PageLoadHandler();
				}
				else if(xmlhttp.responseText.match("updateUnsuccessful"))
				{
					if(language == 0)
					{
						alert("Card " + cardNo + " kernel update operation is not allowed. ");
					}
					else
					{
						alert("卡" + cardNo + "内核升级失败。");
					}
					PageLoadHandler();
				}
				else if(xmlhttp.responseText.match("CardUpdataKernelUnallowed"))
				{
					if(language == 0)
					{
						var updateConfirmResult = confirm("Card is saving parameters now. \r\nContinue?");
					}
					else
					{
						var updateConfirmResult = confirm("卡正在保存参数。\r\n确定继续？");
					}
					if(updateConfirmResult == true)
					{
						updateType = 1;
						CardUpdate(cardNo);
					}
					PageLoadHandler();
				}
				else
				{
					parent.lockType = parent.UPDATEKERNEL;
					parent.LockUI(parent.lockType);
					updataCardKernelStatus(cardNo);
				}
			}
		}
		xmlhttp.send(params);
	}
	else 
	{
		return false;
	}
	
}

function updataCardKernelStatus(cardNo)
{
	var xmlhttp = getHTTPObject();
	var params = "type=27&cmd=1&cardUpdataKernel=" + cardNo + "&userName=" + userName;
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(xmlhttp.responseText.match("updateSuccessful"))
			{
				if(language == 0)
				{
					alert("Card " + cardNo +  " kernel update succseefully, the card is rebooting, please wait.");
				}
				else
				{
					alert("卡" + cardNo + "内核升级成功，正在重启，请耐心等待。");
				}
				PageLoadHandler();
			}
			else if(xmlhttp.responseText.match("updateUnsuccessful"))
			{
				if(language == 0)
				{
					alert("Card " + cardNo + " kernel update operation is not allowed. ");
				}
				else
				{
					alert("卡" + cardNo + "内核升级失败。");
				}
				PageLoadHandler();
			}
			else
			{
				setTimeout(function(){updataCardKernelStatus(cardNo)}, 5000);
			}
		}
	}
	xmlhttp.send(params);
}
